"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const log = __importStar(require("loglevel"));
const wurl_1 = __importDefault(require("wurl"));
const INJECT_CSS_PATH = path.join(__dirname, '../..', 'inject/inject.css');
function isOSX() {
    return os.platform() === 'darwin';
}
exports.isOSX = isOSX;
function isLinux() {
    return os.platform() === 'linux';
}
exports.isLinux = isLinux;
function isWindows() {
    return os.platform() === 'win32';
}
exports.isWindows = isWindows;
function linkIsInternal(currentUrl, newUrl, internalUrlRegex) {
    if (newUrl === 'about:blank') {
        return true;
    }
    if (internalUrlRegex) {
        const regex = RegExp(internalUrlRegex);
        return regex.test(newUrl);
    }
    const currentDomain = wurl_1.default('domain', currentUrl);
    const newDomain = wurl_1.default('domain', newUrl);
    return currentDomain === newDomain;
}
exports.linkIsInternal = linkIsInternal;
function shouldInjectCss() {
    try {
        fs.accessSync(INJECT_CSS_PATH);
        return true;
    }
    catch (e) {
        return false;
    }
}
exports.shouldInjectCss = shouldInjectCss;
function getCssToInject() {
    return fs.readFileSync(INJECT_CSS_PATH).toString();
}
exports.getCssToInject = getCssToInject;
/**
 * Helper to print debug messages from the main process in the browser window
 */
function debugLog(browserWindow, message) {
    // Need a delay, as it takes time for the preloaded js to be loaded by the window
    setTimeout(() => {
        browserWindow.webContents.send('debug', message);
    }, 3000);
    log.info(message);
}
exports.debugLog = debugLog;
function getAppIcon() {
    return path.join(__dirname, `../../icon.${isWindows() ? 'ico' : 'png'}`);
}
exports.getAppIcon = getAppIcon;
function nativeTabsSupported() {
    return isOSX();
}
exports.nativeTabsSupported = nativeTabsSupported;
function getCounterValue(title) {
    const itemCountRegex = /[([{]([\d.,]*)\+?[}\])]/;
    const match = itemCountRegex.exec(title);
    return match ? match[1] : undefined;
}
exports.getCounterValue = getCounterValue;
//# sourceMappingURL=helpers.js.map